<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AzureADSettingsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $rules = [
            'enabled' => 'required|boolean',
        ];

        if ($this->input('enabled')) {
            $rules += [
                'clientId' => 'required|string|max:255',
                'tenantId' => 'required|string|max:255',
                'clientSecret' => 'required|string|max:255',
                'redirectUri' => 'required|url|max:255',
            ];
        }

        return $rules;
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'clientId.required' => 'Client ID is required when Azure AD is enabled',
            'tenantId.required' => 'Tenant ID is required when Azure AD is enabled',
            'clientSecret.required' => 'Client Secret is required when Azure AD is enabled',
            'redirectUri.required' => 'Redirect URI is required when Azure AD is enabled',
            'redirectUri.url' => 'Redirect URI must be a valid URL',
        ];
    }
}
