<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SMTPSettingsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'host' => 'required|string|max:255',
            'port' => 'required|integer|min:1|max:65535',
            'username' => 'required|string|max:255',
            'password' => 'required|string|max:255',
            'useTLS' => 'required|boolean',
            'fromEmail' => 'required|email|max:255',
            'fromName' => 'required|string|max:255',
        ];
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'host.required' => 'SMTP host is required',
            'port.required' => 'SMTP port is required',
            'port.integer' => 'SMTP port must be a number',
            'port.min' => 'SMTP port must be between 1 and 65535',
            'port.max' => 'SMTP port must be between 1 and 65535',
            'fromEmail.email' => 'From email must be a valid email address',
        ];
    }
}
