<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Carbon\Carbon;

class UpdateVisitRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'hostLocation' => 'sometimes|exists:locations,id',
            'mainVisitorEmail' => 'sometimes|email|max:255',
            'visitReason' => 'sometimes|string|min:10|max:1000',
            'meetingType' => 'sometimes|in:single,multiple',

            // Single day meeting (optional)
            'date' => 'sometimes|date|after_or_equal:today',
            'startTimeHour' => 'sometimes|integer|between:1,12',
            'startTimeMinute' => 'sometimes|in:00,15,30,45',
            'startTimeAmPm' => 'sometimes|in:AM,PM',
            'endTimeHour' => 'sometimes|integer|between:1,12',
            'endTimeMinute' => 'sometimes|in:00,15,30,45',
            'endTimeAmPm' => 'sometimes|in:AM,PM',

            // Multiple day meeting (optional)
            'dateFrom' => 'sometimes|date|after_or_equal:today',
            'dateTo' => 'sometimes|date|after:dateFrom',
        ];
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'hostLocation.exists' => 'Selected location does not exist',
            'mainVisitorEmail.email' => 'Please provide a valid email address',
            'visitReason.min' => 'Visit reason must be at least 10 characters',
            'date.after_or_equal' => 'Meeting date must be today or in the future',
            'dateTo.after' => 'End date must be after start date',
        ];
    }
}
