<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VisitStatusHistory extends Model
{
    use HasFactory;

    protected $table = 'visit_status_history';
    const UPDATED_AT = null; // Only uses created_at

    protected $fillable = [
        'visit_id',
        'from_status',
        'to_status',
        'changed_by_email',
        'changed_by_name',
        'reason',
    ];

    /**
     * Get the visit for this history entry
     */
    public function visit()
    {
        return $this->belongsTo(Visit::class);
    }

    /**
     * Get the user who made the change
     */
    public function changedBy()
    {
        return $this->belongsTo(UserRole::class, 'changed_by_email', 'email');
    }
}
