<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('visitors', function (Blueprint $table) {
            $table->id();
            $table->foreignId('visit_id')->constrained('visits')->onDelete('cascade');

            // Visitor Information
            $table->string('name', 255);
            $table->string('email', 255);
            $table->string('phone', 20);
            $table->string('company_name', 255)->nullable();

            // ID Document Images
            $table->string('id_front_image', 255)->nullable();
            $table->string('id_back_image', 255)->nullable();

            // Visitor Type
            $table->boolean('is_main_visitor')->default(false);

            $table->timestamps();

            // Indexes
            $table->index('visit_id');
            $table->index('email');
            $table->index(['is_main_visitor', 'visit_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('visitors');
    }
};
