<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('visit_status_history', function (Blueprint $table) {
            $table->id();
            $table->foreignId('visit_id')->constrained('visits')->onDelete('cascade');

            $table->string('from_status', 50)->nullable();
            $table->string('to_status', 50);

            $table->string('changed_by_email', 255)->nullable();
            $table->string('changed_by_name', 255)->nullable();
            $table->text('reason')->nullable();

            $table->timestamp('created_at')->useCurrent();

            // Foreign Keys
            $table->foreign('changed_by_email')->references('email')->on('user_roles')->onDelete('set null');

            // Indexes
            $table->index('visit_id');
            $table->index('created_at');
            $table->index('changed_by_email');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('visit_status_history');
    }
};
