<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('email_templates', function (Blueprint $table) {
            $table->id();
            $table->string('name', 255);
            $table->enum('type', [
                'visit_created_host',
                'visit_created_visitor',
                'after_submission_security',
                'after_submission_host',
                'after_approval_visitor',
                'after_approval_host',
                'security_return',
                'reminder',
                'rejection'
            ])->unique();
            $table->string('subject', 255);
            $table->text('body');
            $table->json('variables');
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            $table->index('type');
            $table->index('is_active');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('email_templates');
    }
};
