<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\EmailTemplate;

class EmailTemplatesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $templates = [
            [
                'name' => 'Visit Created - Host',
                'type' => 'visit_created_host',
                'subject' => 'Visit Request Created - {{requestId}}',
                'body' => '<p>Dear {{host}},</p><p>Your visit request has been created successfully.</p><p><strong>Request ID:</strong> {{requestId}}<br><strong>Visitor Email:</strong> {{visitor.email}}<br><strong>Location:</strong> {{location}}<br><strong>Meeting Date:</strong> {{meetingDate}}<br><strong>Reason:</strong> {{reason}}</p><p>The visitor will receive an invitation to register their details.</p><p>Best regards,<br>Beyti Visitor Management Team</p>',
                'variables' => ['{{host}}', '{{requestId}}', '{{visitor.email}}', '{{location}}', '{{meetingDate}}', '{{reason}}'],
                'is_active' => true,
            ],
            [
                'name' => 'Visit Created - Visitor',
                'type' => 'visit_created_visitor',
                'subject' => 'You have been invited - {{requestId}}',
                'body' => '<p>Dear Visitor,</p><p>You have been invited to visit <strong>{{location}}</strong> by {{host}}.</p><p><strong>Meeting Date:</strong> {{meetingDate}}<br><strong>Reason:</strong> {{reason}}</p><p>Please click the link below to complete your registration:</p><p><a href="{{registrationUrl}}">Complete Registration</a></p><p>Best regards,<br>Beyti Visitor Management Team</p>',
                'variables' => ['{{visitor.email}}', '{{host}}', '{{location}}', '{{meetingDate}}', '{{reason}}', '{{registrationUrl}}'],
                'is_active' => true,
            ],
            [
                'name' => 'After Submission - Security',
                'type' => 'after_submission_security',
                'subject' => 'New Visit Registration - {{requestId}}',
                'body' => '<p>Security Team,</p><p>A new visit registration requires your review.</p><p><strong>Request ID:</strong> {{requestId}}<br><strong>Host:</strong> {{host}}<br><strong>Visitor:</strong> {{visitor.name}} ({{visitor.email}})<br><strong>Location:</strong> {{location}}<br><strong>Meeting Date:</strong> {{meetingDate}}</p><p>Please review and approve/reject this visit request.</p><p>Best regards,<br>Beyti Visitor Management System</p>',
                'variables' => ['{{requestId}}', '{{host}}', '{{visitor.name}}', '{{visitor.email}}', '{{location}}', '{{meetingDate}}'],
                'is_active' => true,
            ],
            [
                'name' => 'After Submission - Host',
                'type' => 'after_submission_host',
                'subject' => 'Visitor Registered - {{requestId}}',
                'body' => '<p>Dear {{host}},</p><p>The visitor has completed their registration for request <strong>{{requestId}}</strong>.</p><p><strong>Visitor:</strong> {{visitor.name}}<br><strong>Meeting Date:</strong> {{meetingDate}}</p><p>The request is now pending security approval.</p><p>Best regards,<br>Beyti Visitor Management Team</p>',
                'variables' => ['{{host}}', '{{visitor.name}}', '{{requestId}}', '{{meetingDate}}'],
                'is_active' => true,
            ],
            [
                'name' => 'After Approval - Visitor',
                'type' => 'after_approval_visitor',
                'subject' => 'Visit Approved - Welcome!',
                'body' => '<p>Dear {{visitor.name}},</p><p>Your visit to <strong>{{location}}</strong> has been approved!</p><p><strong>Meeting Date:</strong> {{meetingDate}}<br><strong>Host:</strong> {{host}}</p><p>Please arrive on time and bring your ID. Looking forward to seeing you!</p><p>Best regards,<br>Beyti Visitor Management Team</p>',
                'variables' => ['{{visitor.name}}', '{{location}}', '{{meetingDate}}', '{{host}}'],
                'is_active' => true,
            ],
            [
                'name' => 'After Approval - Host',
                'type' => 'after_approval_host',
                'subject' => 'Visit Approved - {{requestId}}',
                'body' => '<p>Dear {{host}},</p><p>Your visit request <strong>{{requestId}}</strong> has been approved by security.</p><p><strong>Visitor:</strong> {{visitor.name}}<br><strong>Meeting Date:</strong> {{meetingDate}}</p><p>The visitor has been notified and will arrive at the scheduled time.</p><p>Best regards,<br>Beyti Visitor Management Team</p>',
                'variables' => ['{{host}}', '{{visitor.name}}', '{{requestId}}', '{{meetingDate}}'],
                'is_active' => true,
            ],
            [
                'name' => 'Security Return',
                'type' => 'security_return',
                'subject' => 'Visit Returned for Corrections - {{requestId}}',
                'body' => '<p>Dear {{host}},</p><p>Your visit request <strong>{{requestId}}</strong> has been returned for corrections.</p><p><strong>Reason:</strong> {{reason}}</p><p><strong>Visitor:</strong> {{visitor.email}}</p><p>Please contact the visitor to provide updated information or clearer ID images.</p><p>Registration link: <a href="{{registrationUrl}}">{{registrationUrl}}</a></p><p>Best regards,<br>Beyti Visitor Management Team</p>',
                'variables' => ['{{host}}', '{{visitor.email}}', '{{reason}}', '{{requestId}}', '{{registrationUrl}}'],
                'is_active' => true,
            ],
            [
                'name' => 'Reminder',
                'type' => 'reminder',
                'subject' => 'Reminder: Complete Your Visit Registration',
                'body' => '<p>Dear Visitor,</p><p>This is a friendly reminder to complete your visit registration.</p><p><strong>Host:</strong> {{host}}<br><strong>Meeting Date:</strong> {{meetingDate}}</p><p>Please click the link below to complete your registration:</p><p><a href="{{registrationUrl}}">Complete Registration</a></p><p>Best regards,<br>Beyti Visitor Management Team</p>',
                'variables' => ['{{visitor.email}}', '{{host}}', '{{meetingDate}}', '{{registrationUrl}}'],
                'is_active' => true,
            ],
            [
                'name' => 'Rejection',
                'type' => 'rejection',
                'subject' => 'Visit Request Rejected - {{requestId}}',
                'body' => '<p>Dear {{host}},</p><p>We regret to inform you that your visit request <strong>{{requestId}}</strong> has been rejected.</p><p><strong>Visitor:</strong> {{visitor.email}}<br><strong>Reason:</strong> {{reason}}</p><p>If you have any questions, please contact the security team.</p><p>Best regards,<br>Beyti Visitor Management Team</p>',
                'variables' => ['{{host}}', '{{visitor.email}}', '{{reason}}', '{{requestId}}'],
                'is_active' => true,
            ],
        ];

        foreach ($templates as $template) {
            EmailTemplate::updateOrCreate(
                ['type' => $template['type']],
                $template
            );
        }

        $this->command->info('Email templates seeded successfully!');
    }
}
