<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Location;

class LocationsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $locations = [
            [
                'name' => 'Cairo Main Office',
                'code' => 'CAI-001',
                'address' => 'Downtown Cairo, Egypt',
                'is_active' => true,
            ],
            [
                'name' => 'Alexandria Branch',
                'code' => 'ALX-001',
                'address' => 'Alexandria, Egypt',
                'is_active' => true,
            ],
            [
                'name' => 'Giza Branch',
                'code' => 'GIZ-001',
                'address' => 'Giza, Egypt',
                'is_active' => true,
            ],
        ];

        foreach ($locations as $location) {
            Location::updateOrCreate(
                ['code' => $location['code']],
                $location
            );
        }

        $this->command->info('Locations seeded successfully!');
    }
}
