<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\UserRole;

class TestUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create admin user
        UserRole::updateOrCreate(
            ['email' => 'admin@beyti.test'],
            [
                'email' => 'admin@beyti.test',
                'role' => 'admin',
                'is_active' => true,
            ]
        );

        // Create security admin user
        UserRole::updateOrCreate(
            ['email' => 'security.admin@beyti.test'],
            [
                'email' => 'security.admin@beyti.test',
                'role' => 'security_admin',
                'is_active' => true,
            ]
        );

        // Create security member user
        UserRole::updateOrCreate(
            ['email' => 'security@beyti.test'],
            [
                'email' => 'security@beyti.test',
                'role' => 'security_member',
                'is_active' => true,
            ]
        );

        // Create host user
        UserRole::updateOrCreate(
            ['email' => 'host@beyti.test'],
            [
                'email' => 'host@beyti.test',
                'role' => 'user',
                'is_active' => true,
            ]
        );

        $this->command->info('Test users created successfully!');
        $this->command->info('Admin: admin@beyti.test');
        $this->command->info('Security Admin: security.admin@beyti.test');
        $this->command->info('Security Member: security@beyti.test');
        $this->command->info('Host: host@beyti.test');
    }
}
